:setvar DatabaseName "RegistryQA"
:setvar MajorReleaseNumber "1"
:setvar MinorReleaseNumber "0"
:setvar PointReleaseNumber "48"
:setvar DeployVersion "20150715.1"

SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;
GO

/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END
GO

PRINT 'Step 4 - Registry.Database.Descriptions.sql
Version Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)
BUILD $(DeployVersion)
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

 ';
 
 PRINT ' 

*********************************************************
========================================================
ANY
    ERRORS 
            RECEIVED 
                      DURING
                              THE
                                  EXECUTION 
                                          OF  THIS
                                                  SCRIPT
            MAY    BE    IGNORED .
========================================================
THIS SCRIPT DOES NOT AFFECT THE OPERATION OF THE SYSTEM.
========================================================

';
GO

USE [$(DatabaseName)]
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO

SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_CONCEPT].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_CONCEPT', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_CONCEPT].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_CONCEPT', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_CONCEPT].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_CONCEPT', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_CONCEPT].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_CONCEPT', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_CONCEPT].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_CONCEPT', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[STD_TERM_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table. An identity column.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM', @level2type = N'COLUMN', @level2name = N'STD_TERM_ID';


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[STD_CONCEPT_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the STD_CONCEPT table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM', @level2type = N'COLUMN', @level2name = N'STD_CONCEPT_ID';


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[SYSTEM_STD_TERM_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The lexicon or coding system in which the term was pulled from and codified within.  For example, ICD-9 for diagnosis terms from that version of the ICD.  Systems are themselves terms so this is a self-join foreign key.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM', @level2type = N'COLUMN', @level2name = N'SYSTEM_STD_TERM_ID';


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[FORM_RESPONSE_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table. An IDENTITY surrogate key.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE', @level2type = N'COLUMN', @level2name = N'FORM_RESPONSE_ID';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[REGISTRANT_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the REGISTRANT table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE', @level2type = N'COLUMN', @level2name = N'REGISTRANT_ID';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[STD_FORM_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the STD_FORM table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE', @level2type = N'COLUMN', @level2name = N'STD_FORM_ID';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[FORM_RESPONSE_ANSWER_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table.  An IDENTITY surrogate key.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_ANSWER', @level2type = N'COLUMN', @level2name = N'FORM_RESPONSE_ANSWER_ID';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[FORM_RESPONSE_QUESTION_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the FORM_RESPONSE_DETAIL table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_ANSWER', @level2type = N'COLUMN', @level2name = N'FORM_RESPONSE_QUESTION_ID';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[STD_FORM_ANSWER_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the STD_FORM_ANSWER table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_ANSWER', @level2type = N'COLUMN', @level2name = N'STD_FORM_ANSWER_ID';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[ANSWER_VALUE].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The answer provided by the participant.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_ANSWER', @level2type = N'COLUMN', @level2name = N'ANSWER_VALUE';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_ANSWER', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_ANSWER', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_ANSWER', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_ANSWER', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_ANSWER', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_STATUS].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_STATUS', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_STATUS].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_STATUS', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_STATUS].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_STATUS', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_STATUS].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_STATUS', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_STATUS].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_STATUS', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[PROCESS_METRICS].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'PROCESS_METRICS', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[PROCESS_METRICS].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'PROCESS_METRICS', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[PROCESS_METRICS].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'PROCESS_METRICS', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[PROCESS_METRICS].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'PROCESS_METRICS', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[PROCESS_METRICS].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'PROCESS_METRICS', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_FORM].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER_FIELD].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER_FIELD', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER_FIELD].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER_FIELD', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER_FIELD].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER_FIELD', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER_FIELD].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER_FIELD', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER_FIELD].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_ANSWER_FIELD', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[STD_FORM_SECTION_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Unique Section Identifier', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'STD_FORM_SECTION_ID';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[STD_FORM_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Unique Section Identifier', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'STD_FORM_ID';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[BRP_FORM_SECTION_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Section Identifier in Veteran Portal application.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'BRP_FORM_SECTION_ID';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[MENU_ITEM_NAME].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Text used for the Menu in Clinical Portal application.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'MENU_ITEM_NAME';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[TOOL_TIP].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Tool Tip Text displayed in Clinical Portal application.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'TOOL_TIP';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SECTION', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[STD_FORM_SUB_SECTION_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Unique Sub Section Identifier', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'STD_FORM_SUB_SECTION_ID';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[STD_FORM_SECTION_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Unique Section Identifier', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'STD_FORM_SECTION_ID';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[STD_FORM_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Unique Form Identifier', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'STD_FORM_ID';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[BRP_FORM_SUB_SECTION_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Sub Section Identifier in Veteran Portal application.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'BRP_FORM_SUB_SECTION_ID';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[MENU_ITEM_NAME].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Text used for the Menu in Clinical Portal application.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'MENU_ITEM_NAME';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[TOOL_TIP].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Tool Tip Text displayed in Clinical Portal application.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'TOOL_TIP';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_SUB_SECTION', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_PROCESS_METRICS_TYPE].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_PROCESS_METRICS_TYPE', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_PROCESS_METRICS_TYPE].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_PROCESS_METRICS_TYPE', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_PROCESS_METRICS_TYPE].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_PROCESS_METRICS_TYPE', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_PROCESS_METRICS_TYPE].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_PROCESS_METRICS_TYPE', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_PROCESS_METRICS_TYPE].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_PROCESS_METRICS_TYPE', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[STD_REGISTRANT_STATUS_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'An IDENTITY surrogate key acting as the PK for the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRANT_STATUS', @level2type = N'COLUMN', @level2name = N'STD_REGISTRANT_STATUS_ID';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[REGISTRANT_STATUS].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The name of the status, unique within the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRANT_STATUS', @level2type = N'COLUMN', @level2name = N'REGISTRANT_STATUS';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[ORDINAL_VALUE].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A value indicating the relative position in the registration workflow.  Higher values are later in the workflow.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRANT_STATUS', @level2type = N'COLUMN', @level2name = N'ORDINAL_VALUE';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRANT_STATUS', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRANT_STATUS', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRANT_STATUS', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRANT_STATUS', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRANT_STATUS', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A flag (a.k.a., tag or label) that can be used to associate a registrant with a group, status/state or requirement.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[STD_REGISTRY_FLAG_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table. An IDENTITY surrogate key.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'STD_REGISTRY_FLAG_ID';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[REGISTRY_FLAG_NAME].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique name of the flag (a.k.a., tag).', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'REGISTRY_FLAG_NAME';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[REGISTRY_FLAG_DESCRIPTION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A description of the flag (a.k.a., tag)', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'REGISTRY_FLAG_DESCRIPTION';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[STD_REGISTRY_FLAG_TYPE_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the STD_REGISTRY_FLAG_TYPE table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'STD_REGISTRY_FLAG_TYPE_ID';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[ACTIVE_FLAG].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A flag to indicate whether this record is used when assigning new flags. 1 (true/active) 0 (false/inactive)', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'ACTIVE_FLAG';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[PREDEFINED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A flag to indicate whether this record is predefined which does not allow front end user to modify. 1 (true/predefined) 0 (false/not predefined)', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'PREDEFINED';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last  updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS].[SERVICE_STATUS].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The name of the status, unique within the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_STATUS', @level2type = N'COLUMN', @level2name = N'SERVICE_STATUS';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_STATUS', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_STATUS', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_STATUS', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_STATUS', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_STATUS', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG_TYPE].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG_TYPE', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG_TYPE].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG_TYPE', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG_TYPE].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG_TYPE', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG_TYPE].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG_TYPE', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG_TYPE].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_REGISTRY_FLAG_TYPE', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_REGISTRY_FLAG', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[REGISTRANT_EMAIL_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table. An IDENTITY surrogate key.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_EMAIL', @level2type = N'COLUMN', @level2name = N'REGISTRANT_EMAIL_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[REGISTRANT_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the REGISTRANT_CONTACT_INFO table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_EMAIL', @level2type = N'COLUMN', @level2name = N'REGISTRANT_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[TYPE].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'e.g., WORK, HOME, etc', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_EMAIL', @level2type = N'COLUMN', @level2name = N'TYPE';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_EMAIL', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_EMAIL', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_EMAIL', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_EMAIL', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_EMAIL', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[REGISTRANT_DEPLOYMENT_ID].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table. An IDENTITY surrogate key.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_DEPLOYMENT', @level2type = N'COLUMN', @level2name = N'REGISTRANT_DEPLOYMENT_ID';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[REGISTRANT_ID].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the REGISTRANT table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_DEPLOYMENT', @level2type = N'COLUMN', @level2name = N'REGISTRANT_ID';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[CREATEDBY].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_DEPLOYMENT', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[UPDATEDBY].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_DEPLOYMENT', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[CREATED].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_DEPLOYMENT', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[UPDATED].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_DEPLOYMENT', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[ROW_VERSION].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_DEPLOYMENT', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO].[REGISTRANT_ID].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table.  FK to the REGISTRANT_INFO table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_CONTACT_INFO', @level2type = N'COLUMN', @level2name = N'REGISTRANT_ID';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO].[CREATEDBY].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_CONTACT_INFO', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO].[UPDATEDBY].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_CONTACT_INFO', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO].[CREATED].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_CONTACT_INFO', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO].[UPDATED].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_CONTACT_INFO', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO].[ROW_VERSION].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_CONTACT_INFO', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[REGISTRANT_ADDRESS_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table.  An IDENTITY surrogate key.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_ADDRESS', @level2type = N'COLUMN', @level2name = N'REGISTRANT_ADDRESS_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[REGISTRANT_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the REGISTRANT_CONTACT_INFO table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_ADDRESS', @level2type = N'COLUMN', @level2name = N'REGISTRANT_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[TYPE].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'e.g., HOME, WORK, etc', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_ADDRESS', @level2type = N'COLUMN', @level2name = N'TYPE';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_ADDRESS', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_ADDRESS', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_ADDRESS', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_ADDRESS', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_ADDRESS', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[STD_HEALTH_FACTOR_CATEGORY_ID].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'An IDENTITY surrogate key used as the PK for the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR_CATEGORY', @level2type = N'COLUMN', @level2name = N'STD_HEALTH_FACTOR_CATEGORY_ID';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[NAME].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The name of the health factor category', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR_CATEGORY', @level2type = N'COLUMN', @level2name = N'NAME';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[DESCRIPTION].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The description of the health factor category', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR_CATEGORY', @level2type = N'COLUMN', @level2name = N'DESCRIPTION';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[ACTIVE_FLAG].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'1 (true) if the record is in current use, 0 if not', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR_CATEGORY', @level2type = N'COLUMN', @level2name = N'ACTIVE_FLAG';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[CREATEDBY].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR_CATEGORY', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[UPDATEDBY].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR_CATEGORY', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[CREATED].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR_CATEGORY', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[UPDATED].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR_CATEGORY', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[ROW_VERSION].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR_CATEGORY', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[NAME].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The name of the health factor', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'NAME';


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[DESCRIPTION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The description of the health factor', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'DESCRIPTION';


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[STD_HEALTH_FACTOR_CATEGORY_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the STD_HEALTH_FACTOR_CATEGORY table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'STD_HEALTH_FACTOR_CATEGORY_ID';


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[ACTIVE_FLAG].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'1 (true) if the record is in current use, 0 if not', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'ACTIVE_FLAG';


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[REGISTRANT_HEALTH_FACTOR_ID].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'An IDENTITY surrogate key used as the PK for the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'REGISTRANT_HEALTH_FACTOR_ID';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[REGISTRANT_VISIT_ID].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the REGISTRANT_VISIT table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'REGISTRANT_VISIT_ID';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[STD_HEALTH_FACTOR_ID].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the STD_HEALTH_FACTOR', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'STD_HEALTH_FACTOR_ID';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[ACTIVE_FLAG].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Indicates whether this factor is a current condition', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'ACTIVE_FLAG';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[CREATEDBY].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[UPDATEDBY].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[CREATED].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[UPDATED].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR].[ROW_VERSION].[MS_Description]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_HEALTH_FACTOR', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[ERROR_LOG].[ERROR_LOG_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'An IDENTITY surrogate key used as the PK for the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'ERROR_LOG', @level2type = N'COLUMN', @level2name = N'ERROR_LOG_ID';


GO
PRINT N'Creating [AHOBPR].[ERROR_LOG].[COMPONENT_TYPE].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'e.g., Database', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'ERROR_LOG', @level2type = N'COLUMN', @level2name = N'COMPONENT_TYPE';


GO
PRINT N'Creating [AHOBPR].[ERROR_LOG].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique identifier for the record.  Required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'ERROR_LOG', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_DEPLOYMENT_LOCATION].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DEPLOYMENT_LOCATION', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_DEPLOYMENT_LOCATION].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DEPLOYMENT_LOCATION', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_DEPLOYMENT_LOCATION].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DEPLOYMENT_LOCATION', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_DEPLOYMENT_LOCATION].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DEPLOYMENT_LOCATION', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_DEPLOYMENT_LOCATION].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DEPLOYMENT_LOCATION', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_BRANCH_OF_SERVICE].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_BRANCH_OF_SERVICE', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_BRANCH_OF_SERVICE].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_BRANCH_OF_SERVICE', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_BRANCH_OF_SERVICE].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_BRANCH_OF_SERVICE', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_BRANCH_OF_SERVICE].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_BRANCH_OF_SERVICE', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_BRANCH_OF_SERVICE].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_BRANCH_OF_SERVICE', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_SERVICE_EPISODE].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_SERVICE_EPISODE', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_SERVICE_EPISODE].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_SERVICE_EPISODE', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_SERVICE_EPISODE].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_SERVICE_EPISODE', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_SERVICE_EPISODE].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_SERVICE_EPISODE', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_SERVICE_EPISODE].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_SERVICE_EPISODE', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'This is an extension to the REGISTRANT table that holds various record control information.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_RECORD_INFO';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO].[REGISTRANT_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table. A FK to REGISTRANT table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_RECORD_INFO', @level2type = N'COLUMN', @level2name = N'REGISTRANT_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_RECORD_INFO', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_RECORD_INFO', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_RECORD_INFO', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_RECORD_INFO', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_RECORD_INFO', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_ANSWER].[STD_TERM_ANSWER_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table. An identity column.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_ANSWER', @level2type = N'COLUMN', @level2name = N'STD_TERM_ANSWER_ID';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_ANSWER].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_ANSWER', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_ANSWER].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_ANSWER', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_ANSWER].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_ANSWER', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_ANSWER].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_ANSWER', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_ANSWER].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_ANSWER', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_VISIT].[STD_INSTITUTION_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The facility at which the encounter occurred. FK to dbo.STD_INSTITUION.ID', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_VISIT', @level2type = N'COLUMN', @level2name = N'STD_INSTITUTION_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_VISIT].[VISTA_EncounterID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Is this a VistA or CDW identifier?', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_VISIT', @level2type = N'COLUMN', @level2name = N'VISTA_EncounterID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_VISIT].[VISTA_Sta3n].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'VA 3-digit station identifier. Facilities have the same Sta3n if they use the same VistA instance.It is char(3), but CDW stores it as varchar(50).', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_VISIT', @level2type = N'COLUMN', @level2name = N'VISTA_Sta3n';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_QUESTION].[STD_TERM_QUESTION_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'PK for the table. An identity column.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_QUESTION', @level2type = N'COLUMN', @level2name = N'STD_TERM_QUESTION_ID';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_QUESTION].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_QUESTION', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_QUESTION].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_QUESTION', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_QUESTION].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_QUESTION', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_QUESTION].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_QUESTION', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_TERM_QUESTION].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_TERM_QUESTION', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_DISCHARGE_CHARACTER].[DISCHARGE_CHARACTER].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The name of the DISCHARGE, unique within the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DISCHARGE_CHARACTER', @level2type = N'COLUMN', @level2name = N'DISCHARGE_CHARACTER';


GO
PRINT N'Creating [AHOBPR].[STD_DISCHARGE_CHARACTER].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DISCHARGE_CHARACTER', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_DISCHARGE_CHARACTER].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DISCHARGE_CHARACTER', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_DISCHARGE_CHARACTER].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DISCHARGE_CHARACTER', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_DISCHARGE_CHARACTER].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DISCHARGE_CHARACTER', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_DISCHARGE_CHARACTER].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_DISCHARGE_CHARACTER', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_FAMILY].[FAMILY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The name of the Component, unique within the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_FAMILY', @level2type = N'COLUMN', @level2name = N'FAMILY';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_FAMILY].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_FAMILY', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_FAMILY].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_FAMILY', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_FAMILY].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_FAMILY', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_FAMILY].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_FAMILY', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_FAMILY].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_FAMILY', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_REASON].[REASON].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The name of the Component, unique within the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_REASON', @level2type = N'COLUMN', @level2name = N'REASON';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_REASON].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_REASON', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_REASON].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_REASON', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_REASON].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_REASON', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_REASON].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_REASON', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_SEPARATION_REASON].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SEPARATION_REASON', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_OCCUPATION].[SERVICE_TITLE].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The name of the Component, unique within the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_OCCUPATION', @level2type = N'COLUMN', @level2name = N'SERVICE_TITLE';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_OCCUPATION].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_OCCUPATION', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_OCCUPATION].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_OCCUPATION', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_OCCUPATION].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_OCCUPATION', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_OCCUPATION].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_OCCUPATION', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_OCCUPATION].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_SERVICE_OCCUPATION', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_COMPONENT].[DESCRIPTION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The name of the Component, unique within the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_COMPONENT', @level2type = N'COLUMN', @level2name = N'DESCRIPTION';


GO
PRINT N'Creating [AHOBPR].[STD_COMPONENT].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_COMPONENT', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_COMPONENT].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_COMPONENT', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_COMPONENT].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_COMPONENT', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_COMPONENT].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_COMPONENT', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_COMPONENT].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_COMPONENT', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[REGISTRANT_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'An IDENTITY surrogate key used as the PK for the table.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'REGISTRANT_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[USER_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The DSLOGON username assigned to the registrant', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'USER_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[EDIPI].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Electronic Data Interchange Personal Identifier. An identifier issued by DMDC for DoD healthcare beneficiaries. ', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'EDIPI';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[ICN].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Integration Control Number.  A VA id created to tie together records about the same patient in multiple VistA instances. ', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'ICN';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[SSN].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Social Security Number. ', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'SSN';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[FIRST_NAME].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'First name of the registrant.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'FIRST_NAME';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[MIDDLE_NAME].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Middle name of the registrant.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'MIDDLE_NAME';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[LAST_NAME].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Last name of the registrant.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'LAST_NAME';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[BIRTH_DATE].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'Birth date of the registrant.  ', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'BIRTH_DATE';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[GENDER].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'i.e., Sex of Registrant', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'GENDER';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[STD_SERVICE_STATUS_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the STD_SERVICE_STATUS table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'STD_SERVICE_STATUS_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[STD_BRANCH_OF_SERVICE_ID_CURRENT].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The registrant''s current branchof service. FK to dbo.STD_BRANCH_OF_SERVICE table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'STD_BRANCH_OF_SERVICE_ID_CURRENT';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The branch of service the registrant was in at the time of registration (first login). FK to dbo.STD_BRANCH_OF_SERVICE table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[STD_REGISTRANT_STATUS_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the STD_REGISTRANT_STATUS table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'STD_REGISTRANT_STATUS_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[STD_INSTITUTION_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'FK to the dbo.STD_INSTITUTION table', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'STD_INSTITUTION_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_QUESTION].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_QUESTION', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_QUESTION].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_QUESTION', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_QUESTION].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_QUESTION', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_QUESTION].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_QUESTION', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[STD_FORM_QUESTION].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'STD_FORM_QUESTION', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[REGISTRANT_PHONE_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The PK for the table. An IDENTITY surrogate key.', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_PHONE', @level2type = N'COLUMN', @level2name = N'REGISTRANT_PHONE_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[REGISTRANT_ID].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'This table is currently joined to REGISTRATION_CONTACT_INFO table (not REGISTRANT). This relationship needs to be validated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_PHONE', @level2type = N'COLUMN', @level2name = N'REGISTRANT_ID';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[TYPE].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'e.g., HOME, WORK, etc', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_PHONE', @level2type = N'COLUMN', @level2name = N'TYPE';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_PHONE', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that last updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_PHONE', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_PHONE', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was last updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_PHONE', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'REGISTRANT_PHONE', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[CREATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that created the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_QUESTION', @level2type = N'COLUMN', @level2name = N'CREATEDBY';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[UPDATEDBY].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The person or program that updated the record', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_QUESTION', @level2type = N'COLUMN', @level2name = N'UPDATEDBY';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[CREATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was created', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_QUESTION', @level2type = N'COLUMN', @level2name = N'CREATED';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[UPDATED].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'The date and time to the second when the record was updated', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_QUESTION', @level2type = N'COLUMN', @level2name = N'UPDATED';


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[ROW_VERSION].[MS_Description]...';


GO
EXECUTE sp_addextendedproperty @name = N'MS_Description', @value = N'A unique row identifier required by LINQ to SQL', @level0type = N'SCHEMA', @level0name = N'AHOBPR', @level1type = N'TABLE', @level1name = N'FORM_RESPONSE_QUESTION', @level2type = N'COLUMN', @level2name = N'ROW_VERSION';


GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('$(MajorReleaseNumber)'
           ,'$(MinorReleaseNumber)'
           ,'$(PointReleaseNumber)'
           ,0
           ,'Step 4 - Registry.Database.Descriptions.sql'
		       ,'Step 4 - Registry.Database.Descriptions.sql Script'
           ,'AHOBPR'
           ,GETDATE());
GO
      

PRINT '';
PRINT 'Step 4 - Registry.Database.Descriptions.sql Complete.';
PRINT '';
PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';
GO